% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.kb.R
\name{example.kb}
\alias{example.kb}
\title{Illustration of the Keyboard Design (Single-agent)}
\usage{
example.kb(center, half_width, s1, s2, a, b)
}
\arguments{
\item{center}{The center of the target key (between 0 and 1).}

\item{half_width}{The width, or tolerable deviation, to each side of the
center (half of the target key's width).}

\item{s1}{The lower boundary of the strongest key.}

\item{s2}{The upper boundary of the strongest key.}

\item{a}{The alpha parameter of the beta distribution.}

\item{b}{The beta parameter of the beta distribution.}
}
\value{
A dose decision plot with the posterior distribution of the DLT rate
of the current dose and the positions of the target and the strongest keys.
}
\description{
This function serves solely as an example to illustrate how the
Keyboard design determines dosing decisions when conducting a single-agent
trial.
}
\details{
It is straightforward to visualize how the Keyboard design determines whether to
stay at the current dose, escalate, or de-escalate. The "target key" (shown in blue) is
the proper dosing interval determined for the trial by the investigators.
The "strongest key" (in red) is the interval with the highest posterior
probability (given the dosage data observed thus far) of the current dose's
true DLT rate. If the strongest key is to the left of the
target key, then we escalate the dose; if the strongest key is to the
right  of the target key, then we de-escalate the dose; and if the strongest
key is the target key, then we retain the current dose. Thus, posterior
probabilities are what directs dosage. Graphically, the strongest key is the
one with the largest area under the posterior distribution curve of the DLT
rate of the current dose.
}
\examples{
## Clear all plots before switching between graphical parameters
opar <- par(no.readonly = TRUE)
on.exit(par(opar))
par(mfrow = c(3, 1)) # for many plots in the same screen
par(mar = c(5, 5, 2, 2)) # for only one plot per page

example.kb(center = 0.19, half_width = 0.03, s1 = 0.4, s2 = 0.46, a = 3, b = 4) # de-escalation
example.kb(center = 0.19, half_width = 0.03, s1 = 0.04, s2 = 0.1, a = 2, b = 12) # escalation
example.kb(center = 0.19, half_width = 0.03, s1 = 0.16, s2 = 0.22, a = 2, b = 5) # stay
}
\references{
Yan F, Mandrekar SJ, Yuan Y. Keyboard: A Novel Bayesian Toxicity Probability
Interval Design for Phase I Clinical Trials.
\emph{Clinical Cancer Research}. 2017; 23:3994-4003.
http://clincancerres.aacrjournals.org/content/23/15/3994.full-text.pdf

Pan H, Lin R, Yuan Y. Keyboard design for phase I drug-combination trials.
\emph{Contemporary Clinical Trials}. 2020.
https://doi.org/10.1016/j.cct.2020.105972
}
\author{
Xiaomeng Yuan, Chen Li, Hongying Sun, Li Tang and Haitao Pan
}
