% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{export_network}
\alias{export_network}
\title{Export ABC results to simple HTML network}
\usage{
export_network(
  abc_results,
  output_file,
  top_n = 50,
  min_score = 0.1,
  open = TRUE
)
}
\arguments{
\item{abc_results}{A data frame containing ABC results from apply_abc_model().}

\item{output_file}{File path for the output HTML file. Must be specified by user.}

\item{top_n}{Number of top results to visualize.}

\item{min_score}{Minimum score threshold for including connections.}

\item{open}{Logical. If TRUE, opens the HTML file after creation.}
}
\value{
The file path of the created HTML file (invisibly).
}
\description{
This function exports ABC results to a simple HTML file with a visualization.
If the visNetwork package is available, it will use it for a more interactive visualization.
}
\examples{
\donttest{
# Create sample ABC results
abc_results <- data.frame(
  a_term = rep("migraine", 3),
  b_term = c("serotonin", "dopamine", "noradrenaline"),
  c_term = c("sumatriptan", "ergotamine", "propranolol"),
  a_b_score = c(0.8, 0.7, 0.6),
  b_c_score = c(0.9, 0.8, 0.7),
  abc_score = c(0.72, 0.56, 0.42)
)

# Export to temporary file
temp_file <- file.path(tempdir(), "network.html")
export_network(abc_results, temp_file, open = FALSE)

# Clean up
unlink(temp_file)
}
}
