% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chandrasekaran.R
\name{sen_chandrasekaran_II_instantaneous}
\alias{sen_chandrasekaran_II_instantaneous}
\title{Instantaneous sensitivity via Chandrasekaran II decomposition}
\usage{
sen_chandrasekaran_II_instantaneous(
  mx,
  age = (1:length(mx1)) - 1,
  nx = rep(1, length(mx)),
  sex = "t",
  perturb = 1e-06,
  closeout = TRUE
)
}
\arguments{
\item{mx}{Numeric vector of mortality rates (central death rates).}

\item{age}{integer vector of the lower bound of each age group (currently only single ages supported)}

\item{nx}{integer vector of age intervals, default 1.}

\item{sex}{Character; "m" for male, "f" for female, or "t" for total.}

\item{perturb}{Numeric; a small constant determining the perturbation size (default 1e-6).}

\item{closeout}{logical. Default \code{TRUE}. Shall we use the HMD Method Protocol to close out the \code{ax} and \code{qx} values? See details.}
}
\value{
numeric vector of sensitivity of life expectancy to perturbations in \code{mx}
}
\description{
Estimates the sensitivity of life expectancy to small changes in mortality rates using the Chandrasekaran II decomposition. This is done by perturbing the input mortality rates up and down by a small factor and calculating the directional sensitivity.

Specifically, the function constructs:
\deqn{m_{x}^{1} = m_x \cdot \left(\frac{1}{1 - h}\right)}
\deqn{m_{x}^{2} = m_x \cdot (1 - h)}
and applies \code{sen_chandrasekaran_II(mx1, mx2, ...)} to the result.
}
\details{
This approach gives a reasonable approximation of the derivative of life expectancy with respect to each age-specific mortality rate. It gives numerically identical results to \code{sen_arriaga_sym_instantaneous()}, \code{sen_lopez_ruzicka_instantaneous()}, and \code{sen_chandrasekaran_III_instantaneous()}.
}
\examples{
a <- 0.001
b <- 0.07
x <- 0:100
mx <- a * exp(x * b)
s <- sen_chandrasekaran_II_instantaneous(mx, age = x)
\donttest{
plot(x, s, type = "l")
}
}
\seealso{
\code{\link{sen_chandrasekaran_II}}, \code{\link{sen_chandrasekaran_II_instantaneous2}}, \code{\link{sen_arriaga_sym_instantaneous}}
}
