% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranef.R
\name{ranef.lmmelsm}
\alias{ranef.lmmelsm}
\alias{ranef}
\title{Extract random effects.}
\usage{
\method{ranef}{lmmelsm}(object, prob = 0.95, summarize = TRUE, ...)
}
\arguments{
\item{object}{lmmelsm object.}

\item{prob}{Numeric (Default: .95). Amount of probability mass contained in the credible interval.}

\item{summarize}{Logical (Default: TRUE). Whether to return posterior summaries (TRUE) or MCMC samples (FALSE).}

\item{...}{Not used.}
}
\value{
List of ranef summaries (random_mu_intercept, random_logsd_intercept, random_mu_coef, and random_logsd_coef), or samples (if summarize = FALSE).
}
\description{
Ranef method for lmmelsm objects.
}
\details{
Extracts the random effects from the lmmelsm object.
Note that this is different from the random \emph{coefficients}.
E.g., if \eqn{\beta_{0i} = \beta_0 + u_{0i}}, then \code{coef} extracts \eqn{\beta_{0i}} and \code{ranef} extracts \eqn{u_{0i}}.
}
\author{
Stephen R. Martin
}
