% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_train.R
\name{model_train}
\alias{model_train}
\title{train a model, easily}
\usage{
model_train(
  data,
  tilde,
  family = c("auto", "lm", "linear", "binomial", "poisson", "rlm")
)
}
\arguments{
\item{data}{Data frame to use as training data}

\item{tilde}{Formula for the model}

\item{family}{Character string: the family of model to fit, e.g. "lm", "binomial", "poisson", "rlm", ...}
}
\value{
An object of class "model_object". This is much the same as an "lm" or "glm" object
but with the additional attribute of the training data and a printing method that
encourages the use of the regression summary methods \code{conf_interval()}, \code{R2()}, or \code{anova_summary()}
}
\description{
An interface to several of the most often used model-fitting routines
designed to make it easy to construct.
}
\details{
Since data may be piped into this function, the training data
frame will be called simply "data", the name of the first argument to this
function. In order to be able to access the training data in such cases, the
training data is assigned to an attribute of the resulting model, "training_data".
}
