% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEP_1t.R
\name{CEP_1t}
\alias{CEP_1t}
\title{Compute classification error probabilities for attributes}
\usage{
CEP_1t(GDINA.obj)
}
\arguments{
\item{GDINA.obj}{a G-DINA model object returned from \code{GDINA} R package.}
}
\value{
a list with elements
\describe{
\item{SL.k}{the sample-level correction weights}
\item{PDL.k}{the posterior distribution level correction weights}
}
}
\description{
Function to compute classification error probabilities (CEP) for attributes (for single time-point situations).Details can be found in Iaconangelo (2017).
}
\examples{
if(requireNamespace("GDINA")){
library(GDINA)
dat <- sim10GDINA$simdat
Q <- matrix(c(1,0,0,
              0,1,0,
              0,0,1,
              1,0,1,
              0,1,1,
              1,1,0,
              0,0,1,
              1,0,0,
              1,1,1,
              1,0,1),byrow = TRUE,ncol = 3)
fit.object <- GDINA(dat = dat, Q = Q, model = "GDINA", att.dist = "independent",verbose = FALSE)
CEP <- CEP_1t(fit.object)
}
}
\references{
Uses of classification error probabilities in the three-step approach to estimating cognitive diagnosis models (Doctoral dissertation). https://rucore.libraries.rutgers.edu/rutgers-lib/55495/PDF/1/play/
}
