% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LexFindR-package.R
\docType{package}
\name{LexFindR-package}
\alias{LexFindR}
\alias{LexFindR-package}
\title{LexFindR: Find Related Items and Lexical Dimensions in a Lexicon}
\description{
Implements code to identify lexical competitors in a given list of words. We include many of the standard competitor types used in spoken word recognition research, such as functions to find cohorts, neighbors, and rhymes, amongst many others. The package includes documentation for using a variety of lexicon files, including those with form codes made up of multiple letters (i.e., phoneme codes) and also basic orthographies. Importantly, the code makes use of multiple CPU cores and vectorization when possible, making it extremely fast and able to handle large lexicons. Additionally, the package contains documentation for users to easily write new functions, allowing researchers to examine other relationships within a lexicon. Preprint: \url{https://osf.io/preprints/psyarxiv/8dyru/}. Open access: \doi{10.3758/s13428-021-01667-6}. Citation: Li, Z., Crinnion, A.M. & Magnuson, J.S. (2021). \doi{10.3758/s13428-021-01667-6}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/maglab-uconn/LexFindR}
  \item Report bugs at \url{https://github.com/maglab-uconn/LexFindR/issues}
}

}
\author{
\strong{Maintainer}: ZhaoBin Li \email{li_zhaobin@icloud.com}

Authors:
\itemize{
  \item Anne Marie Crinnion \email{anne.crinnion@uconn.edu}
  \item James S. Magnuson \email{james.magnuson@uconn.edu} [copyright holder]
}

}
\keyword{internal}
