% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.sullivan.R
\name{Plot.sullivan}
\alias{Plot.sullivan}
\title{Plot Attribution or Decomposition Results Using Sullivan Method}
\usage{
Plot.sullivan(result, var_list = NULL, colors = NULL)
}
\arguments{
\item{result}{A list object returned by either an attribution function (must contain
`Absolute_Contributions_1` and `Absolute_Contributions_2`) or a decomposition function
(must contain `total_effect`, `mortality_effect`, and `disability_effect`).}

\item{var_list}{A character vector specifying the names of variables (e.g., diseases or risk factors)
to include in the plots.}

\item{colors}{Optional. A named character vector of colors for each category (including `"Background"`).
If `NULL`, a color palette will be generated automatically.}
}
\value{
A `patchwork` object combining multiple `ggplot2` barplots. The layout depends on the result type:
\itemize{
  \item For attribution results, four plots are returned: absolute and relative contributions
    to disability and death.
  \item For decomposition results, three plots are returned: total, mortality, and disability effects.
}
}
\description{
This function generates visualization plots for results from either
longitudinal attribution models (e.g., `Attribution_sullivan`) or
decomposition models (e.g., `Decomp_sullivan` ) applied to cohort health expectancy.
}
\details{
This function supports two types of Sullivan-based outputs:
\enumerate{
  \item \strong{Attribution results:} The input should contain components named
    `Absolute_Contributions_1` (for disability) and `Absolute_Contributions_2` (for mortality),
    as returned by the `Attribution_sullivan()` function.
  \item \strong{Decomposition results:} The input should contain `total_effect`, `mortality_effect`,
    and `disability_effect` matrices, typically produced by the `Decomp_sullivan()` function.
}
For attribution results, the function internally computes relative contributions as a share
of total years lost or gained.
}
\examples{
# For attribution result
data(attributionA)
Plot.sullivan(result=attributionA, var_list = c("Z1", "Z2", "Z3"))

# For decomposition result
data(decom_results)
Plot.sullivan(result=decom_results, var_list = c("Z1", "Z2", "Z3"))


}
