% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_mixedGMM.R
\name{est_mixedGMM}
\alias{est_mixedGMM}
\title{Estimating Mixed Correlation Matrix by IGMM}
\usage{
est_mixedGMM(
  dataYX,
  order_indx,
  R0 = NULL,
  app = TRUE,
  korder = 2,
  max_iter = 1000,
  max_tol = 1e-08,
  show_log = FALSE
)
}
\arguments{
\item{dataYX}{a dataframe or matrix containing both continuous and ordinal variables.}

\item{order_indx}{a vector to indicate the ordinal variables.}

\item{R0}{the initial value for correlation vector, default Pearson correlation matrix.}

\item{app}{bool value for approximation, TRUE for Legendre approximation, FALSE for common integral.}

\item{korder}{the order of Legendre approximation.}

\item{max_iter}{max iteration number for IGMM.}

\item{max_tol}{max tolerance for iteration algorithm.}

\item{show_log}{bool value, TRUE for showing calculation log.}
}
\value{
\item{Rhat}{The estimated correlation coefficients.}

\item{COV}{The estimated covariance matrix for Rhat}
}
\description{
An accelerated function to estimate a mixed correlation coefficient matrix, as well as its covariance matrix, for dataframes containing continuous and ordinal variable.
}
\examples{
library(mvtnorm)
library(MASS)
set.seed(1997)
n = 500
rho12=0.3
rho13=0.4
rho14=0.5
rho23=0.6
rho24=0.7
rho34=0.8

R = matrix(c(1,rho12,rho13,rho14,rho12,1,rho23,rho24,rho13,rho23,1,rho34,
rho14,rho24,rho34,1),4,4)
indc = c(3,4)
thresholds = list(c(),c(),0,0)
data1 = gen_mixed(n=n,R=R,indc=indc,thresholds=thresholds)
data2 = data.frame(data1$observed)
out1 = est_mixedGMM(dataYX = data2,order_indx = indc)
print(out1$Rhat)
print(out1$COV)
}
\references{
arXiv:2404.06781
}
