# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#'
#' Compute the Expected Count Matrix from a Contingency Table
#'
#' This function computes the expected counts matrix \eqn{E_{ij}} from a
#' given \eqn{I \times J} contingency table using the formula:
#' \deqn{E_{ij} = \frac{n_{i.} n_{.j}}{n_{..}}}
#' where \eqn{n_{i.}} is the sum of the \eqn{i}-th row, \eqn{n_{.j}} is
#' the sum of the \eqn{j}-th column, and \eqn{n_{..}} is the total sum
#' of the table.
#'
#' @param continTable A numeric matrix representing the \eqn{I \times J}
#' contingency table.
#'
#' @return A numeric matrix of the same dimension as \code{continTable},
#' containing the expected counts for each cell \eqn{(i, j)} of the
#' contingency table. The expected counts are based on the row and column
#' marginal sums of the contingency table.
#'
#' @examples
#' # Create a 6 by 4 contingency table
#' set.seed(42)
#' dat_mat <- matrix(rpois(6*4, 20), nrow=6)
#' dat_mat
#'
#' # Assign row and column names
#' contin_table <- check_and_fix_contin_table(dat_mat)
#' contin_table
#'
#' # Compute the expected counts of the contingency table
#' get_expected_counts(contin_table)
#'
#' @useDynLib MDDC
#' @importFrom Rcpp evalCpp
#' @rdname get_expected_counts
#'
#' @export
get_expected_counts <- function(continTable) {
    .Call('_MDDC_get_expected_counts', PACKAGE = 'MDDC', continTable)
}

#'
#' Standardized Pearson Residuals for Contingency Tables
#'
#' Compute the standardized Pearson residuals \eqn{Z_{ij}} for a given
#' \eqn{I \times J} contingency table. Standardized Pearson residuals
#' are calculated as \eqn{Z_{ij} = \frac{(O_{ij} - E_{ij})}{\sqrt{E_{ij}
#' (1 - p_{i.}) (1 - p_{.j})}}} where \eqn{O_{ij}} is the observed count,
#' \eqn{E_{ij}} is the expected count, and \eqn{p_{i.}} and \eqn{p_{.j}}
#' are the row and column marginal probabilities, respectively.
#'
#' @param continTable A numeric matrix representing the \eqn{I \times J}
#' contingency table.
#' @param na A boolean flag (default is \code{TRUE}) to replace cells with
#' observed counts less than 6 with \code{NA} values.
#'
#' @return A matrix containing:
#' \itemize{
#'   \item A matrix of standardized Pearson residuals (\code{ZijMat}).
#'   \item The total sum of the contingency table (\code{nDotDot}).
#'   \item A vector of row marginal proportions (\code{piDot}).
#'   \item A vector of column marginal proportions (\code{pDotj}).
#' }
#'
#' @useDynLib MDDC
#' @rdname StandardizedPearsonResiduals
#' @keywords internal
#'
#' @noRd
getZijMat <- function(continTable, na = TRUE) {
    .Call('_MDDC_getZijMat', PACKAGE = 'MDDC', continTable, na)
}

#'
#' Compute P-values Based on an Empirical Distribution
#'
#' This function calculates the p-values for each observation in a vector
#' \code{obs} based on a sorted empirical distribution vector \code{dist}.
#' The p-value is calculated as the proportion of values in \code{dist} that
#' are greater than the observation, adjusted for ranking. If an observation
#' is \code{NaN}, the corresponding p-value will be \code{NaN}.
#'
#' @param obs A numeric vector (Eigen::VectorXd) containing the observations
#' for which p-values are to be computed.
#' @param dist A numeric vector (Eigen::VectorXd) representing the empirical
#' distribution from which the p-values will be calculated.
#'
#' @return A numeric vector (Eigen::VectorXd) of p-values corresponding to
#' each observation in \code{obs}. The p-values are based on the number of
#' elements in \code{dist} greater than each observation.
#'
#' @useDynLib MDDC
#' @rdname getPVal
#' @keywords internal
#'
#' @noRd
getPVal <- function(obs, dist) {
    .Call('_MDDC_getPVal', PACKAGE = 'MDDC', obs, dist)
}

#'
#' Generate Contingency Table for Fisher's Exact Test
#'
#' This function constructs a 2x2 contingency table used for performing
#' Fisher's Exact Test. The table is derived from the given contingency
#' matrix \code{continTable} based on the specified row and column indices.
#' The user has the option to exclude data from the same drug class by
#' adjusting the calculations for the contingency table.
#'
#' @param continTable A numeric matrix (Eigen::MatrixXd) representing the
#' contingency table from which the 2x2 table will be constructed.
#' @param rowIdx An integer representing the row index of the element to be
#' used in the contingency table.
#' @param colIdx An integer representing the column index of the element to
#' be used in the contingency table.
#' @param excludeSameDrugClass A boolean value indicating whether to exclude
#' the same drug class in the calculations. If \code{true}, the function
#' will adjust the calculations by excluding the same drug class.
#'
#' @return A 2x2 numeric matrix (Eigen::MatrixXd) representing the contingency
#' table for Fisher's Exact Test.
#'
#' @useDynLib MDDC
#' @rdname getFisherExactTestTable
#' @keywords internal
#'
#' @noRd
getFisherExactTestTable <- function(continTable, rowIdx, colIdx, excludeSameDrugClass) {
    .Call('_MDDC_getFisherExactTestTable', PACKAGE = 'MDDC', continTable, rowIdx, colIdx, excludeSameDrugClass)
}

#' Compute Correlation Matrix with Handling of Missing Values
#'
#' This function calculates a correlation matrix from the input matrix,
#' handling missing values (`NA`) by computing correlations only for
#' non-missing pairs. The function supports computing either row-wise or
#' column-wise correlations, based on the input flag `if_col_cor`.
#'
#' @param mat A numeric matrix or data frame. Each column represents a variable,
#'   and each row represents an observation. The function will compute pairwise
#'   correlations between the columns (or rows if `if_col_cor = FALSE`).
#' @param if_col_cor Logical. If `TRUE`, the function computes correlations
#'   between columns of `mat`. If `FALSE`, correlations are computed between
#'   rows (the matrix is transposed internally).
#'
#' @return A square matrix containing the computed correlation coefficients.
#'   The dimensions of the returned matrix will be equal to the number of
#'   columns (or rows if `if_col_cor = FALSE`) in the input matrix `mat`.
#'   Missing values (`NA`) in the input matrix are handled by only using
#'   observations where both variables have non-missing values. If fewer than
#'   3 valid pairs are available for a correlation, `NA` is returned for
#'   that pair.
#'
#' @details The function iterates through each pair of columns (or rows)
#'   and computes the correlation using Pearson's method, only including
#'   observations where both variables have non-missing values. If the number
#'   of valid pairs is less than 3, the function assigns `NA` to the
#'   corresponding entry in the correlation matrix.
#'
#' @useDynLib MDDC
#' @noRd
pearsonCorWithNA <- function(mat, ifColCorr = TRUE) {
    .Call('_MDDC_pearsonCorWithNA', PACKAGE = 'MDDC', mat, ifColCorr)
}

