% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEA.R
\name{CEA}
\alias{CEA}
\title{Cost-effectiveness analysis}
\usage{
CEA(data, group, cost, effect, B = 5000, currency = "euro")
}
\arguments{
\item{data}{a \code{data.frame} with rows representing observations in for
example a cost-effectiveness trial.}

\item{group}{group variable in \code{data}. Should contain two levels.}

\item{cost}{cost variable in \code{data}.}

\item{effect}{effect variable in \code{data}.}

\item{B}{number of bootstrap samples.}

\item{currency}{currency unit. See ?currency2unicode for options that will return
the a Unicode symbol that will be used in plot.CEA and plot.CEAC. If the parameter
is not listed, the parameter itself will be used. This makes it possible to input
a custom Unicode hex (e.g., \code{"\u00Ae"}). Defaults to "euro".}
}
\value{
\code{CEA} returns a list (class \code{CEA}) with the following elements:
\item{stats}{a \code{data.frame} containing the bootstrap statistics: estimates for
the difference in costs (\code{diffC}), the difference in effects(\code{diffE}),
and the ICER as a ratio of these two.}
\item{diff.C.true}{Observed difference in costs.}
\item{diff.E.true}{Observed difference in effects.}
\item{ICER.true}{Observed incremental cost-effectiveness ratio.}
\item{gr1}{First level of group variable.}
\item{gr2}{Second level of group variable.}
\item{currencyUC}{The currency. Either in raw form (parameter \code{currency}) or as
a Unicode hex.}
}
\description{
Perform a cost-effectiveness analysis. Or a cost-utility analysis.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
CEA(gnomes, insulationMethod, Costs, diffHATS, 5000, "acorns") |>
  plot()
}
\author{
Mathijs Deen
}
