% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CEAC.R
\name{plot.CEAC}
\alias{plot.CEAC}
\title{Plot cost-effectiveness acceptability curve}
\usage{
\method{plot}{CEAC}(
  x,
  xlab = sprintf("Cost-effectiveness threshold (\%s)", x$currencyUC),
  ylab = "Probability that intervention is cost-effective",
  las = 1,
  xlim = c(0, max(x$s$ICERs)),
  ...
)
}
\arguments{
\item{x}{object of class \code{CEAC}}

\item{xlab}{label for x axis}

\item{ylab}{label for y axis}

\item{las}{style of the axis labels (see \code{\link[graphics]{par}})}

\item{xlim}{limits of the x axis}

\item{...}{other arguments to be passed to the \code{plot} function.}
}
\value{
returns a plot
}
\description{
Plot cost-effectiveness acceptability curve
}
\examples{
CEA(gnomes, insulationMethod, Costs, diffHATS, 1000, "acorns") |>
  CEAC() |>
  plot(xlim = c(0,200))
}
\author{
Mathijs Deen
}
