% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.studies.R
\name{run.studies}
\alias{run.studies}
\title{Benchmarking for Multivariate Goodness-of-fit Tests}
\usage{
run.studies(
  study,
  Continuous = TRUE,
  WithEstimation = FALSE,
  Dim = 2,
  TS,
  TSextra,
  With.p.value = FALSE,
  nsample = 250,
  nbins = c(5, 5),
  alpha = 0.05,
  param_alt,
  SuppressMessages = TRUE,
  B = 1000,
  maxProcessor
)
}
\arguments{
\item{study}{either the name of the study, or its number in the list. If missing all the studies are run.}

\item{Continuous}{=TRUE, run cases for continuous data.}

\item{WithEstimation}{=FALSE, run case studies with or without parameter estimation?}

\item{Dim}{=2 two or five-dimensional continuous data sets?}

\item{TS}{routine to calculate new test statistics.}

\item{TSextra}{list passed to TS (optional).}

\item{With.p.value}{=FALSE, does user supplied routine return p values?}

\item{nsample}{= 250, desired sample size. 250 is used in included case studies.}

\item{nbins}{=c(5,5) number of bins for discretized data.}

\item{alpha}{=0.05,  type I error probability of tests. 0.05 is used in included case studies.}

\item{param_alt}{(list of) values of parameter under the alternative hypothesis.
If missing included values are used.}

\item{SuppressMessages}{=TRUE, should informative messages be shown?}

\item{B}{= 1000, number of simulation runs.}

\item{maxProcessor}{number of cores to use. If missing the number of physical cores-1
is used. If set to 1 no parallel processing is done.}
}
\value{
A (list of ) matrices of p.values.
}
\description{
This function runs the case studies included in the package.
}
\details{
For details consult vignette(package="MDgof")
}
\examples{
#Examples are run with a super small B=25 simulation runs to satisfy CRAN submission rules.
#Run a new test for studies 1-3 for continuous data and without estimation.
#The new test is an (included) chi square test that finds it's own p value.
TSextra=list(Continuous=TRUE, WithEstimation=FALSE, Withpvalue=TRUE)
MDgof::run.studies(Continuous=TRUE, WithEstimation=FALSE, 
           study=1:3, TS=MDgof::newTS, TSextra=TSextra, 
           With.p.value = TRUE, B=25, maxProcessor = 1)
#Run included tests for studies 1-3 for discrete data and without estimation,
#but with type I error alpha=0.1
p=MDgof::power_studies_disc_results[[3]][1:3,,drop=FALSE]    
MDgof::run.studies(Continuous=FALSE, WithEstimation=FALSE, 
           study=1:3, param_alt=p,alpha=0.1, B=25, maxProcessor = 1)         
}
