% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericBasisSeries2fun.R
\name{numericBasisSeries2fun}
\alias{numericBasisSeries2fun}
\alias{numericBasisSeries2fun,numericBasis_series,numeric-method}
\title{Compute the value of the basis function summation series at certain points.}
\usage{
numericBasisSeries2fun(object, x)

\S4method{numericBasisSeries2fun}{numericBasis_series,numeric}(object, x)
}
\arguments{
\item{object}{an object of \code{\link{numericBasis_series}} class.}

\item{x}{Value of $x$.}
}
\value{
A numeric atomic vector
}
\description{
Compute the function \eqn{f(x) = \sum_{k=0}^{p}c_k \rho_{k}(x)}, \eqn{x\in\Omega}
}
\examples{
t_0 = 0
period = 1
t_points = seq(0.05,0.95,length.out = 19)
nb = numeric_basis(
  basis_function = cbind(1/2,cos(2*pi*t_points),sin(2*pi*t_points)),
  t_points       = t_points,
  t_0            = t_0,
  period         = period
)
ns = numericBasis_series(coef = c(0.8,1.2,1.6),numeric_basis = nb)
numericBasisSeries2fun(ns,seq(0,1,length.out = 51))

}
\author{
Heyang Ji
}
