% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcExpKernel}
\alias{calcExpKernel}
\title{Calculate Exponential Stochastic Matrix}
\usage{
calcExpKernel(distMat, rate)
}
\arguments{
\item{distMat}{Distance matrix from \code{\link[MGDrivE]{calcVinEll}}}

\item{rate}{Rate parameter of \code{\link[stats]{Exponential}} distribution}
}
\description{
Given a distance matrix from \code{\link[MGDrivE]{calcVinEll}}, calculate a
stochastic matrix where one step movement probabilities follow an exponential density.
}
\details{
The distribution and density functions for the exponential kernel are given below:
\deqn{
F(x)=1-e^{-\lambda x}
}
\deqn{
f(x)=\lambda e^{-\lambda x}
}
where \eqn{\lambda} is the rate parameter of the exponential distribution.
}
\examples{
# setup distance matrix
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# Vincenty Ellipsoid  distance formula
distMat = calcVinEll(latLongs = latLong)

# calculate exponential distribution over distances
#  rate is just for example
kernMat = calcExpKernel(distMat = distMat, rate = 10)

}
