% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Htest.R
\name{Htest}
\alias{Htest}
\title{Test for homoskedasticity at level one}
\usage{
Htest(newdata, fml, group)
}
\arguments{
\item{newdata}{data to be used.}

\item{fml}{level 1 formula.}

\item{group}{grouping variable (in quotes).}
}
\value{
Returns a data frame which contains:
\item{H}{The computed H statistic.}
\item{df}{The degrees of freedom.}
\item{p}{The p-value (< .05 indicates heteroskedasticity is present).}
}
\description{
Based on Raudenbush and Bryk (2002) and Hoffman (2007).
A statistically significant Chisq indicates heteroskedasticity.
Output shows the H statistic, degrees of freedom, and p value.
}
\examples{
set.seed(123)
x1 <- rnorm(400)
y <- x1 * .3 + rnorm(400)
gr <- rep(1:20, each = 20)
dat <- data.frame(x1, y, gr)
Htest(dat, y ~ x1, 'gr') #no violation
y <- x1 * .3 + rnorm(400, 0, sqrt(x1^2)) #add violation
dat <- data.frame(x1, y, gr)
Htest(dat, y ~ x1, 'gr')
}
\references{
\cite{Hoffman, L. (2007). Multilevel models for examining individual differences in within-person variation and covariation over time. \emph{Multivariate Behavioral Research, 42}(4), 609–629.}
\cite{Raudenbush, S., & Bryk, A. (2002). \emph{Hierarchical linear models: Applications and data analysis methods (2nd ed.)}. Sage.}
}
