% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pugs.R
\name{predict.ECC}
\alias{predict.ECC}
\title{Classify new samples using an Ensemble of Classifier Chains}
\usage{
\method{predict}{ECC}(object, newdata, n.iters = 300, burn.in = 100,
  thin = 2, run_parallel = FALSE, silent = TRUE, .f = NULL, ...)
}
\arguments{
\item{object}{An object of type \code{ECC} returned by \code{\link{ecc}()}.}

\item{newdata}{A data frame or matrix of features. Must be the same form as
the one used with \code{\link{ecc}()}.}

\item{n.iters}{Number of iterations of the Gibbs sampler.}

\item{burn.in}{Number of iterations for adaptation (burn-in).}

\item{thin}{Thinning interval.}

\item{run_parallel}{Logical flag for utilizing multicore capabilities of the
system.}

\item{silent}{Logical flag indicating whether to have a progress bar (if
the 'progress' package is installed) or print progress messages to console.}

\item{.f}{User-supplied prediction function that corresponds to the type of
classifier that was trained in the \code{\link{ecc}()} step. See Details.}

\item{...}{additional arguments to pass to \code{.f}.}
}
\value{
An object of class \code{PUGS} containing: \itemize{
 \item \code{y_labels} : inherited from \code{object}
 \item \code{preds} : A burnt-in, thinned multi-dimensional array of predictions.
}
}
\description{
Uses a trained ECC and Gibbs sampling to predict labels for new
  samples. \code{.f} must return a matrix of probabilities, one row for each
  observation in \code{newdata}.
}
\details{
Getting the prediction function correct is very important here.
  Since this package is a wrapper that can use any classification algorithm
  as its base classifier, certain assumptions have been made. We assume that
  the prediction function can return a data.frame or matrix of probabilities
  with two columns: "0" and "1" because \code{\link{ecc}()} trains on a
  factor of "0"s and "1"s for more universal consistency.
}
\examples{
x <- movies_train[, -(1:3)]
y <- movies_train[, 1:3]

model_glm <- ecc(x, y, m = 1, .f = glm.fit, family = binomial(link = "logit"))

predictions_glm <- predict(model_glm, movies_test[, -(1:3)],
.f = function(glm_fit, newdata) {

  # Credit for writing the prediction function that works
  # with objects created through glm.fit goes to Thomas Lumley
  
  eta <- as.matrix(newdata) \%*\% glm_fit$coef
  output <- glm_fit$family$linkinv(eta)
  colnames(output) <- "1"
  return(output)
  
}, n.iters = 10, burn.in = 0, thin = 1)

\dontrun{

model_c50 <- ecc(x, y, .f = C50::C5.0)
predictions_c50 <- predict(model_c50, movies_test[, -(1:3)],
                           n.iters = 10, burn.in = 0, thin = 1,
                           .f = C50::predict.C5.0, type = "prob")
  
model_rf <- ecc(x, y, .f = randomForest::randomForest)
predictions_rf <- predict(model_rf, movies_test[, -(1:3)],
                          n.iters = 1000, burn.in = 100, thin = 10,
                          .f = function(rF, newdata) {
                            randomForest:::predict.randomForest(rF, newdata, type = "prob")
                          })
}
}

