% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_MRFnetworks.R
\name{predict_MRFnetworks}
\alias{predict_MRFnetworks}
\title{Extract predicted network metrics for observations in a given dataset using
equations from a fitted \code{MRFcov} object}
\usage{
predict_MRFnetworks(
  data,
  MRF_mod,
  cutoff,
  omit_zeros,
  metric,
  cached_predictions = NULL,
  prep_covariates,
  n_cores,
  progress_bar = FALSE
)
}
\arguments{
\item{data}{Dataframe. The sample data where the
left-most variables are variables that are represented by nodes in the graph.
Colnames from this sample dataset must exactly match the colnames in the dataset that
was used to fit the \code{MRF_mod}}

\item{MRF_mod}{A fitted \code{MRFcov} or \code{bootstrap_MRF} object}

\item{cutoff}{Single numeric value specifying the linear prediction threshold. Species whose
linear prediction is below this level for a given observation in \code{data} will be
considered absent, meaning they cannot participate in community networks.
Default is \code{0.5} for \code{family == 'binomial'} or \code{0} for other families}

\item{omit_zeros}{Logical. If \code{TRUE}, each species will not be considered to
participate in community networks for observations in which that species was not observed
in \code{data}. If \code{FALSE}, the species is still considered to have possibly occurred, based
on the linear prediction for that observation. Default is \code{FALSE}}

\item{metric}{The network metric to be calculated for each observation in \code{data}.
Recognised values are : \code{"degree"}, \code{"eigencentrality"}, or \code{"betweenness"}, or
leave blank to instead return a list of adjacency matrices}

\item{cached_predictions}{Use if providing stored predictions from \code{\link{predict_MRF}}
to prevent unneccessary replication. Default is to calculate predictions first and then
calculate network metrics}

\item{prep_covariates}{Logical flag stating whether to prep the dataset
by cross-multiplication (\code{TRUE} by default; use \code{FALSE} for predicting
networks from \code{\link{MRFcov_spatial}} objects)}

\item{n_cores}{Positive integer stating the number of processing cores to split the job across.
Default is \code{1} (no parallelisation)}

\item{progress_bar}{Logical. Progress bar in pbapply is used if \code{TRUE}, but this slows estimation.}
}
\value{
Either a \code{matrix} with \code{nrow = nrow(data)},
containing each species' predicted network metric at each observation in \code{data}, or
a \code{list} with \code{length = nrow(data)} containing the weighted, undirected
adjacency matrix predicted at each observation in \code{data}
}
\description{
This function uses outputs from fitted \code{\link{MRFcov}}
and \code{\link{bootstrap_MRF}} models to
generate linear predictions for each observation in \code{data} and
calculate probabilistic network metrics from weighted adjacency matrices.
}
\details{
Interaction parameters are predicted for each observation in \code{data}
and then converted into a weighted, undirected adjacency matrix
using \code{\link[igraph]{graph.adjacency}}. Note that the network is probabilistic,
as node occurrences/abundances are predicted using fitted model equations from
\code{MRF_mod}. If a linear prediction for a given observation falls below the
user-specified \code{cutoff}, the node is considered absent from the community and cannot
participate in the network. After correcting for the linear predictions,
the specified network metric (degree centrality,
eigencentrality, or betweenness) for each observation in \code{data}
is then calculated and returned in a \code{matrix}. If \code{metric} is not
supplied, the weighted, undirected adjacency matrices are returned in a \code{list}
}
\examples{
data("Bird.parasites")
CRFmod <- MRFcov(data = Bird.parasites, n_nodes = 4,
                family = "binomial")
predict_MRFnetworks(data = Bird.parasites[1:200, ],
                   MRF_mod = CRFmod, metric = "degree",
                   cutoff = 0.25)


}
\seealso{
\code{\link{MRFcov}}, \code{\link{bootstrap_MRF}}, \code{\link[igraph]{degree}},
\code{\link[igraph]{eigen_centrality}}, \code{\link[igraph]{betweenness}}
}
