% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_stats.R
\name{shape_stats}
\alias{shape_stats}
\title{Computes Sample Skew and Kurtosis}
\usage{
shape_stats(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
A list with two elements:
\describe{
\item{skew}{Skew of Data from \code{skew()}}
\item{kurt}{Kurtosis of Data from \code{kurt()}}
}
}
\description{
Calculates the skewness of a numeric vector (via \code{skew()}).
A positive value indicates right skew (long right tail), while a negative value
indicates left skew (long left tail). A zero value represents symmetry.
Calculates the kurtosis of a numeric vector (via \code{kurt()}).
A value near 0 suggests normal kurtosis (mesokurtic),
positive values indicate heavier tails (leptokurtic), and negative
values indicate lighter tails (platykurtic).
}
\examples{
# Shape stats of mpg in mtcars
data("mtcars")
shape_stats(mtcars$mpg)


}
