% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigTen_colors.R
\name{get_bigten_colors}
\alias{get_bigten_colors}
\title{Big Ten Institution Primary & Sceondary Color Palette}
\usage{
get_bigten_colors(institutions, type = "primary")
}
\arguments{
\item{institutions}{Character vector of institution names (should match names in bigten_colors_primary)}

\item{type}{Either "primary" or "secondary" colors}
}
\value{
Named character vector of hex colors
}
\description{
Get Big Ten colors for specific institutions
}
\examples{
# Get primary colors for specific institutions
get_bigten_colors(c("Michigan", "Ohio State", "MSU"))

# Get secondary colors
get_bigten_colors(c("Michigan", "Northwestern"), type = "secondary")

# Use in ggplot with scale_fill_manual
library(ggplot2)
my_colors <- get_bigten_colors(c("Michigan", "Ohio State", "MSU"))
BigTenData <- data.frame(
  institution = c("Michigan", "Ohio State", "MSU"),
  value = c(10, 15, 20)
)
ggplot(data=BigTenData) +
  geom_bar(aes(x = institution, y = value, fill = institution),
           stat="identity") +
  scale_fill_manual(values = my_colors)
}
