% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CodeEff_Matrix.R
\name{CodeEff_Matrix}
\alias{CodeEff_Matrix}
\title{Function Used To Estimate Code Effects}
\usage{
CodeEff_Matrix(
  S.1,
  S.2,
  n1,
  n2,
  U.1,
  U.2,
  V.1,
  V.2,
  common_codes,
  zeta.int,
  lambda,
  p
)
}
\arguments{
\item{S.1}{SPPMI from the source site.}

\item{S.2}{SPPMI from the target site.}

\item{n1}{The number of codes from the source site.}

\item{n2}{The number of codes from the target site.}

\item{U.1}{The left embeddings left singular vectors times the square root of the singular values from the source site.}

\item{U.2}{The left embeddings left singular vectors times the square root of the singular values from the target site.}

\item{V.1}{The right embeddings right singular vectors times the square root of the singular values from the source site.}

\item{V.2}{The right embeddings right singular vectors times the square root of the singular values from the target site.}

\item{common_codes}{The list of overlapping codes.}

\item{zeta.int}{The initial estimator for the code effects.}

\item{lambda}{The tuning parameter controls the intensity of penalization on the code effect.}

\item{p}{The length of an embedding.}
}
\value{
A list with the following elements:
\item{zeta}{The estimated code effects.}
\item{dif_F}{The Frobenius norm difference between the updated and initial estimators.}
\item{V.1.new}{Updated right embeddings for the source site.}
\item{V.2.new}{Updated right embeddings for the target site.}
}
\description{
This function estimates code effects using left and right embeddings from source and target sites.
}
