% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rccc.R
\name{rccc}
\alias{rccc}
\title{Robust Concordance Correlation Coefficient (rCCC)}
\usage{
rccc(x, y, alpha = 0.75)
}
\arguments{
\item{x}{Numeric vector; first variable.}

\item{y}{Numeric vector; second variable.}

\item{alpha}{Numeric in (0.5, 1]; MCD subset size proportion. Default 0.75.}
}
\value{
A list with one element:
\item{coef}{Robust concordance correlation coefficient}
}
\description{
Computes a robust concordance correlation coefficient using
Minimum Covariance Determinant (MCD) estimates.
}
\details{
The rCCC replaces means and (co)variances in Lin's CCC with their
MCD counterparts: \eqn{\rho_c = \frac{2\sigma_{xy}}{\sigma_x^2+\sigma_y^2+(\mu_x-\mu_y)^2}}.
}
\examples{
if (requireNamespace("robustbase", quietly = TRUE)) {
  set.seed(1)
  x <- rnorm(50)
  y <- 2 + 3*x + rnorm(50, mean = 3)
  rccc(x, y)
}

}
\references{
Bulut, H. (2025). A Robust Concordance Correlation Coefficient. (Unpublished)
}
\author{
Hasan BULUT <hasan.bulut@omu.edu.tr>
}
