% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2mtch.R
\name{createWeights}
\alias{createWeights}
\title{Das and Dennis's structured weight generation, normal boundary intersection (NBI).}
\usage{
createWeights(nDim, axisDivision = nDim + 2, noZero = FALSE)
}
\arguments{
\item{nDim}{The dimensionality of the problem. In EA, usually this is used in the objective space, hence nDim = nObjective}

\item{axisDivision}{Used only when no weights are supplied. An input for the structured weight distribution. This defines how many division are created in each axis.}

\item{noZero}{Default to false. If set to TRUE, reference vector containing zero, e.g. (1,0,0) will be removed. Used to generate weight in modified tch method.}
}
\value{
The function return a set of weight vectors.
}
\description{
Generate a set of weights following Das and Dennis's method. Each column returned is a weight vector.
}
\examples{
nObjective <- 3
axisDiv <- 6

createWeights(nObjective,axisDiv)
}
\references{
Indraneel Das and J. E. Dennis. 1998. Normal-Boundary Intersection: A New Method for Generating the Pareto Surface in Nonlinear Multicriteria Optimization Problems. SIAM Journal on Optimization 1998 8:3, 631-657.
}
