% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MaddisonCountries.R
\docType{data}
\name{MaddisonCountries}
\alias{MaddisonCountries}
\title{Maddison Project data}
\format{
\subsection{\code{MaddisonCountries}}{

A data frame with 3 columns:
\describe{
\item{ISO}{3-letter ISO country code}
\item{country}{Country name used by the Maddison project}
\item{region}{Geographic region including \code{country}}
}

Its \code{rownames} = \code{ISO}.
}
}
\source{
\url{https://www.rug.nl/ggdc/historicaldevelopment/maddison/releases/maddison-project-database-2020?lang=en}"Groningen Growth and Development Centre"
}
\usage{
MaddisonCountries
}
\description{
The
\href{https://en.wikipedia.org/wiki/Maddison_Project}{Maddison project}
collates historical economic statistics from many sources.
\code{MaddisonCountries} is a \code{\link{data.frame}} of all (\code{countrycode}, \code{country},
\code{region}) combinations in those data.
}
\examples{
# Get the country for a countrycode (IS)
subset(MaddisonCountries, ISO=='GBR', country)
# Or
MaddisonCountries['GBR', 'country']
# Find Yugoslavia 
subset(MaddisonCountries, grepl('Yugo', country), 1:3)
# number of countries by region 
table(MaddisonCountries$region)
# What are "Western Offshoots"? 
subset(MaddisonCountries, grepl('Of', region), c(country, ISO))
}
\keyword{datasets}
