% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plotuspar.R, R/readuspar.R
\name{plotuspar}
\alias{plotuspar}
\alias{readuspar}
\title{Plot the understorey PAR points}
\usage{
plotuspar(what = c("PARbeam", "PARtotal", "PARdiffuse", "APAR"),
  dataset = NULL, day = 1, hour = NA, xlim = NULL, ylim = NULL,
  makepdf = FALSE, outputfile = "aparunderstorey.pdf", scaleeach = TRUE,
  addNarrow = TRUE)

readuspar(filename = "uspar.dat")
}
\arguments{
\item{what}{Either 'diff', 'apar', 'ipar', or 'beam' (the default).}

\item{dataset}{If left alone, reads the uspar dataset.}

\item{day}{Which day to use, if left alone uses the first day only.}

\item{hour}{Which hour to plot. If left alone, makes a plot for each hour.}

\item{xlim,ylim}{X- and Y-axis limits.}

\item{makepdf}{Logical. If TRUE, produces a pdf in the working directory.}

\item{outputfile}{Name of the pdf file.}

\item{scaleeach}{Logical. Rescale grey scale for each plot, or same for all
hours?}

\item{addNarrow}{Logical. Add an arrow pointing North.}

\item{filename}{The understorey file}
}
\value{
A lattice device, or a pdf.
}
\description{
Reads the 'uspar.dat' file in the current working directory, and plots the
incident or absorbed (or diffuse, or direct) PAR at the understorey points.
Either produces a plot, or makes a pdf with a plot for each hour of the
selected day.

Reads the point-wise output file when the understorey was simulated.
}
\details{
If addNarrow is TRUE, attempts to read the trees.dat file in the current
working directory as well. Prints a warning when this file cannot be opened.
}
\examples{
\dontrun{

# Plot one hour of the first day, showing incident PAR on understorey:
plotuspar("ipar", day=1,hour=12,makepdf=FALSE)

# Make pdf of the whole day, plotting beam radiation:
plotuspar("beam", day=1, outputfile="beam uspar")

}
}
\author{
Remko Duursma
}

