% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMWRcens.R
\name{checkMWRcens}
\alias{checkMWRcens}
\title{Check censored data}
\usage{
checkMWRcens(censdat, warn = TRUE)
}
\arguments{
\item{censdat}{input data frame for results}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
\code{censdat} is returned as is if no errors are found, otherwise an informative error message is returned prompting the user to make the required correction to the raw data before proceeding. Checks with warnings can be fixed at the discretion of the user before proceeding.
}
\description{
Check censored data
}
\details{
This function is used internally within \code{\link{readMWRcens}} to run several checks on the input data for completeness and conformance.

The following checks are made:
\itemize{
\item Column name spelling: Should be the following: Parameter, Missed and Censored Records
\item Columns present: All columns from the previous check should be present
\item Non-numeric or empty entries in Missed and Censored Records: All values should be numbers
\item Negative Missed and Censored Records: All values should be greater than or equal to zero
\item Parameter: Should match parameter names in the \code{Simple Parameter} or \code{WQX Parameter} columns of the \code{\link{paramsMWR}} data (warning only)
}
}
\examples{
censpth <- system.file('extdata/ExampleCensored.xlsx', package = 'MassWateR')

censdat <- suppressWarnings(readxl::read_excel(censpth, na = c('NA', 'na', ''), guess_max = Inf)) 
             
checkMWRcens(censdat)
}
