% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estRs.R
\name{estRs}
\alias{estRs}
\title{Estimate solar radiation (Rs)}
\usage{
estRs(
  x,
  n,
  lat.rad = NULL,
  lat.deg = NULL,
  tl,
  control = list(as = 0.25, bs = 0.5)
)
}
\arguments{
\item{x}{date-time object or Day of the year}

\item{n}{actual duration of sunshine [hour]}

\item{lat.rad}{latitude [rad] (either lat.rad or lat.deg). Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{lat.deg}{latitude [degree] (either lat.rad or lat.deg). Latitude is positive for the northern hemisphere and negative for the southern hemisphere}

\item{tl}{length of calculation period [hour] (1 for hourly, 0.5 for a 30-minute or 24 for daily period).
Only needed if length of x is date-time object with length of 1.}

\item{control}{list for control parameters and empirical factors defined in \code{\link{controlDefaults}} and \code{\link{constDefaults}} (see Details)}
}
\value{
solar or shortwave radiation (Rs) [MJ/(m2 day)]
}
\description{
Rs is calculated from relative sunshine duration and extraterrestrial radiation with the Angstrom formula.
}
\details{
\describe{\item{control:}{
as: regression constant, expressing fraction of extraterrestrial radiation reaching earth on overcast days (n = 0) (default = 0.25) \cr \cr
bs: as + bs fraction of extraterrestrial radiation reaching earth on clear days (n = N) (default = 0.5)}}
\describe{\item{x:}{
must be provided as.numeric (1-366) or as a common date-time object (e.g, POSIXct, POSIXlt or Date objects).
All formats for which is.timepoint from the lubridate package returns TRUE can be used}}
}
\note{
eq. 35 of reference
}
\examples{
estRs(x = 135, n = 7, lat.rad = NULL, lat.deg = -22.9)
}
\references{
Allen, R. G., Pereira, L. S., Raes, D., & Smith, M. (1998). Crop evapotranspiration-Guidelines for computing crop water requirements-FAO Irrigation and drainage paper 56. FAO, Rome, 300(9).
}
