% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hc_companies.R
\name{get_hc_companies}
\alias{get_hc_companies}
\title{Get Companies from Health Canada Drug Product Database}
\source{
Health Canada Drug Product Database (DPD) API:
\url{https://health-products.canada.ca/api/documentation/dpd-documentation-en.html}
}
\usage{
get_hc_companies()
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{company_code}: Unique identifier for the company
  \item \code{company_name}: Official registered name of the company
  \item \code{company_type}: Type of company (e.g., "DIN OWNER", "Manufacturer")
  \item \code{city_name}: City where the company is located
  \item \code{province_name}: Province or territory (if applicable)
  \item \code{country_name}: Country name
  \item \code{postal_code}: Postal code or ZIP code
  \item \code{street_name}: Street address
}
}
\description{
Retrieves information on all pharmaceutical companies listed in the
Health Canada Drug Product Database (DPD) using the
RESTful API endpoint \code{/drug/company}.

This includes details such as the company code, company name,
address, city, province, postal code, and country.
Each record corresponds to a company associated with one or more
approved or discontinued drug products.
}
\details{
This function sends a GET request to the Health Canada Drug Product Database API.
It supports caching via the \pkg{memoise} package to avoid redundant calls,
and includes a small rate limit delay between successive API requests.

The columns \code{post_office_box} and \code{suite_number} are automatically
removed as they generally contain incomplete or irrelevant information.

If the API request fails or returns an error status code,
the function returns \code{NULL} with an informative message.
}
\note{
Requires an active internet connection.
}
\examples{
\donttest{
  # This function requires an internet connection and downloads data from Health Canada
  get_hc_companies()
}

}
\seealso{
\code{\link[httr]{GET}},
\code{\link[jsonlite]{fromJSON}},
\code{\link[dplyr]{as_tibble}}
}
