% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetAlyzer_handler.R
\name{filterMetaData}
\alias{filterMetaData}
\title{Filter meta data}
\usage{
filterMetaData(metalyzer_se, ..., inplace = FALSE)
}
\arguments{
\item{metalyzer_se}{SummarizedExperiment}

\item{...}{Use ´col_name´ and condition to filter selected variables.}

\item{inplace}{If FALSE, return a copy. Otherwise, do operation inplace and
return None.}
}
\value{
An updated SummarizedExperiment
}
\description{
This function updates the "Filter" column in meta_data to
filter out samples.
}
\examples{
metalyzer_se <- MetAlyzer_dataset(file_path = example_extraction_data())

metalyzer_se <- filterMetaData(metalyzer_se, !is.na(Tissue))
metalyzer_se <- filterMetaData(metalyzer_se, `Sample Description` \%in\% 1:6)
# or
filterMetaData(metalyzer_se, !is.na(Tissue), inplace = TRUE)
filterMetaData(metalyzer_se, `Sample Description` \%in\% 1:6, inplace = TRUE)
}
