% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_functions.R
\name{delete_stop_words}
\alias{delete_stop_words}
\alias{delete_stop_words,MetaNLP-method}
\title{Delete stop words}
\usage{
delete_stop_words(object, ...)

\S4method{delete_stop_words}{MetaNLP}(object, ...)
}
\arguments{
\item{object}{A MetaNLP object, whose data frame is to be modified.}

\item{...}{Language of the stop words. Defaults to "english".}
}
\value{
An object of class \code{MetaNLP}.
}
\description{
Usually, stop words do not offer useful information in the classification
whether a paper should be included or excluded
from a meta-analysis. Thus, such words should not be part of the document-term
matrix. This function allows the user to automatically delete stop words.
}
\details{
This function allows to delete stop words from different languages. Supported
languages are \code{english}, \code{french}, \code{german}, \code{russian} and
\code{spanish}. Language names are case sensitive.
}
\examples{
path <- system.file("extdata", "test_data.csv", package = "MetaNLP", mustWork = TRUE)
obj <- MetaNLP(path)
obj <- delete_stop_words(obj, "english")

}
