% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/aSPU.R
\name{ranking}
\alias{ranking}
\title{ranking the OTUs}
\usage{
ranking(y, X, tree, cov = NULL,gamma,g.taxon.index,model = "binomial")
}
\arguments{
\item{y}{Outcome of interest. It can be a disease indicator; =0 for controls, =1 for cases.
Or it can be a quantitative trait. A vector with length n (number of observations).}
\item{X}{OTU count table, row - n sample, column - q OTU}
\item{tree}{Rooted phylogenetic tree of R class \dQuote{phylo}}
\item{cov}{Covariates. A matrix with dimension n by p (n :number of observation, p : number of covariates).}
\item{gamma}{The best gamma selected by aMiSPU test.}
\item{g.taxon.index}{g.taxon.index = 1 stands for weigted generalized taxon proportion; otherwise means unweighted generalized taxon proportion.}
\item{model}{Use "gaussian" for a quantitative trait, and use "binomial" for a binary trait.}
}
\value{
A matrix containing the ranking score, the higher the more important.
}
\description{
Ranking the importance of each taxa.
}
\examples{
data(throat.otu.tab)
data(throat.tree)
data(throat.meta)

Y.tmp =throat.meta[,3]
Y = rep(0,dim(throat.meta)[1])
Y[Y.tmp=="Smoker"] = 1

cov.tmp = throat.meta[,c(10,12)]
cov = matrix(1,dim(throat.meta)[1],2)
cov[cov.tmp[,1]== "None",1] = 0
cov[cov.tmp[,2]== "Male",2] = 0

start.time = proc.time()
X = as.matrix(throat.otu.tab)

#out = MiSPU(Y,X, throat.tree,cov,model =  "binomial", pow = c(2:8, Inf), n.perm = 1000)
out = ranking(Y,X, throat.tree,cov,gamma = 2, g.taxon.index =1)

}
\author{
Chong Wu
}
\references{
Chong, W., Pan, W. (2015) An Adaptive Association Test for Microbiome Data, submitted. 
}


