% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_list_item.R
\docType{class}
\name{ms_list_item}
\alias{ms_list_item}
\title{SharePoint list item}
\format{
An R6 object of class \code{ms_list_item}, inheriting from \code{ms_object}.
}
\description{
Class representing an item in a SharePoint list.
}
\section{Fields}{

\itemize{
\item \code{token}: The token used to authenticate with the Graph host.
\item \code{tenant}: The Azure Active Directory tenant for the parent drive.
\item \code{type}: always "drive item" for a drive item object.
\item \code{properties}: The item properties (data and metadata). This is a list; the item data can be found in the \code{fields} component.
}
}

\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new object. Do not call this directly; see 'Initialization' below.
\item \code{delete(confirm=TRUE)}: Delete this item. By default, ask for confirmation first.
\item \code{update(...)}: Update the item's properties (metadata) in Microsoft Graph. To update the list \emph{data}, update the \code{fields} property. See the examples below.
\item \code{do_operation(...)}: Carry out an arbitrary operation on the item.
\item \code{sync_fields()}: Synchronise the R object with the item data and metadata in Microsoft Graph.
}
}

\section{Initialization}{

Creating new objects of this class should be done via the \code{get_item} method of the \code{\link{ms_list}} class. Calling the \code{new()} method for this class only constructs the R object; it does not call the Microsoft Graph API to retrieve or create the actual item.
}

\examples{
\dontrun{

site <- get_sharepoint_site("My site")
lst <- site$get_list("mylist")

lst_items <- lst$list_items(as_data_frame=FALSE)

item <- lst_items[[1]]

item$update(fields=list(firstname="Mary"))

# item data (plus some metadata mixed in)
item$properties$fields

item$delete()

}
}
\seealso{
\code{\link[AzureGraph:ms_graph]{AzureGraph::ms_graph}}, \code{\link{ms_site}}, \code{\link{ms_list}}

\href{https://learn.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://learn.microsoft.com/en-us/graph/api/resources/sharepoint?view=graph-rest-1.0}{SharePoint sites API reference}
}
