% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minTriadicClosure.R
\name{minTriadicClosure}
\alias{minTriadicClosure}
\title{minTriadicClosure}
\usage{
minTriadicClosure(triadDegree, smoothing_k = 1)
}
\arguments{
\item{triadDegree}{Integer threshold for triangle count.}

\item{smoothing_k}{Numeric smoothing parameter.}
}
\value{
A LOLOG change statistic object.
}
\description{
A smoothed triadic‐closure statistic for LOLOG models.
}
\details{
Returns a registered LOLOG change statistic that smoothly counts how many
nodes are in at least `triadDegree` triangles, using a smoothing parameter.
}
\examples{
registerMinTriadicClosure()  # call once to register the C++ class
stat <- minTriadicClosure(2, 1.5)
print(stat)

}
