% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{are_modality_even_depth}
\alias{are_modality_even_depth}
\title{Test if the mean number of sequences by samples is link to the modality of
a factor}
\usage{
are_modality_even_depth(physeq, fact, boxplot = FALSE)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{boxplot}{(logical) Do you want to plot boxplot?}
}
\value{
The result of a Kruskal-Wallis rank sum test
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


The aim of this function is to provide a warnings if samples depth significantly
vary among the modalities of a factor present in the \code{sam_data} slot.

This function apply a Kruskal-Wallis rank sum test to the number of sequences
per samples in function of the factor \code{fact}.
}
\examples{

are_modality_even_depth(data_fungi_mini, "Time")$p.value
are_modality_even_depth(rarefy_even_depth(data_fungi_mini), "Time")$p.value
are_modality_even_depth(data_fungi_mini, "Height", boxplot = TRUE)
}
\author{
Adrien Taudière
}
