% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{track_wkflow}
\alias{track_wkflow}
\title{Track the number of reads (= sequences), samples and cluster (e.g. ASV)
from various objects including dada-class and derep-class.}
\usage{
track_wkflow(
  list_of_objects,
  obj_names = NULL,
  clean_pq = FALSE,
  taxonomy_rank = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{list_of_objects}{(required) a list of objects}

\item{obj_names}{A list of names corresponding to the list of objects}

\item{clean_pq}{(logical)
If set to TRUE, empty samples and empty ASV are discarded
before clustering.}

\item{taxonomy_rank}{A vector of int. Define the column number of
taxonomic rank \verb{in physeq@tax_table} to compute the number of unique value.
Default is NULL and do not compute values for any taxonomic rank}

\item{verbose}{(logical) If true, print some additional messages.}

\item{...}{Additional arguments passed on to \code{\link[=clean_pq]{clean_pq()}} function.}
}
\value{
The number of sequences, clusters (e.g. OTUs, ASVs) and samples for
each object.
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}

\itemize{
\item List of fastq and fastg.gz files -> nb of reads and samples
\item List of dada-class -> nb of reads, clusters (ASV) and samples
\item List of derep-class -> nb of reads, clusters (unique sequences)
and samples
\item Matrix of samples x clusters (e.g. \code{otu_table}) -> nb of reads,
clusters and samples
\item Phyloseq-class -> nb of reads, clusters and samples
}
}
\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "windows") withAutoprint(\{ # examplesIf}
data(enterotype)
if (requireNamespace("pbapply")) {
  track_wkflow(list(data_fungi, enterotype), taxonomy_rank = c(3, 5))
  track_wkflow(list(
    "data FUNGI" = data_fungi,
    "fastq files forward" =
      unlist(list_fastq_files(system.file("extdata", package = "MiscMetabar"),
        paired_end = FALSE
      ))
  ))
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=track_wkflow_samples]{track_wkflow_samples()}}
}
\author{
Adrien Taudière
}
