% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EstDep.R
\name{EstDep}
\alias{EstDep}
\title{Kendall's tau and Spearman's rho statistics  for testing independence between random variables}
\usage{
EstDep(x, graph = FALSE)
}
\arguments{
\item{x}{Data matrix}

\item{graph}{Set to TRUE for a dependogram for all pairs of Kendall's taus and Spearman's rhos.}
}
\value{
\item{stat}{List of Kendall's tau and Spearman's rho statistics from multilinear copula, and test combinations LB}

\item{pvalue}{P-values for the tests statistics}
}
\description{
This function computes the matrix of pairs of Kendall's tau and Spearman's rho statistics between random variables with arbitrary distributions.
}
\examples{
x <- matrix(rnorm(500),ncol=10)
out <-EstDep(x)
}
\references{
Genest, Neslehova, Remillard & Murphy (2018). Testing for independence in arbitrary distributions
}
