% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogc.mobps.R
\name{ogc.mobps}
\alias{ogc.mobps}
\title{Breeding function}
\usage{
ogc.mobps(
  population,
  animallist,
  relationship.matrix.ogc,
  depth.pedigree.ogc,
  bve.pedigree.error,
  ogc.target = "min.sKin",
  ogc.uniform = NULL,
  ogc.lb = NULL,
  ogc.ub = NULL,
  ogc.ub.sKin = NULL,
  ogc.lb.BV = NULL,
  ogc.ub.BV = NULL,
  ogc.eq.BV = NULL,
  ogc.ub.sKin.increase = NULL,
  ogc.lb.BV.increase = NULL,
  bve.p_i.list = NULL,
  miraculix = FALSE,
  miraculix.mult = FALSE,
  import.position.calculation = NULL,
  decodeOriginsU = decodeOriginsR,
  nbits = NULL,
  store.sparse = FALSE,
  verbose = TRUE,
  bit.storing = FALSE
)
}
\arguments{
\item{population}{Population list}

\item{animallist}{List of individuals to include in ogc}

\item{relationship.matrix.ogc}{Method to calculate relationship matrix for OGC (Default: "pedigree", alt: "vanRaden", "CE", "non_stand", "CE2", "CM")}

\item{depth.pedigree.ogc}{Depth of the pedigree in generations (default: 7)}

\item{bve.pedigree.error}{Set to FALSE to ignore/correct for any pedigree errors}

\item{ogc.target}{Target of OGC (default: "min.sKin" - minimize inbreeding; alt: "max.BV" / "min.BV" - maximize genetic gain; both under constrains selected below)}

\item{ogc.uniform}{This corresponds to the uniform constrain in optiSel}

\item{ogc.lb}{This corresponds to the lb constrain in optiSel}

\item{ogc.ub}{This corresponds to the ub constrain in optiSel}

\item{ogc.ub.sKin}{This corresponds to the ub.sKin constrain in optiSel}

\item{ogc.lb.BV}{This corresponds to the lb.BV constrain in optiSel}

\item{ogc.ub.BV}{This corresponds to the ub.BV constrain in optiSel}

\item{ogc.eq.BV}{This corresponds to the eq.BV constrain in optiSel}

\item{ogc.ub.sKin.increase}{This corresponds to the upper bound (current sKin + ogc.ub.sKin.increase) as ub.sKin in optiSel}

\item{ogc.lb.BV.increase}{This corresponds to the lower bound (current BV + ogc.lb.BV.increase) as lb.BV in optiSel}

\item{bve.p_i.list}{XXX}

\item{miraculix}{XXX}

\item{miraculix.mult}{XXX}

\item{import.position.calculation}{XXX}

\item{decodeOriginsU}{XXX}

\item{nbits}{XXX}

\item{store.sparse}{XXX}

\item{verbose}{Set to FALSE to not display any prints}

\item{bit.storing}{Set to TRUE if the MoBPS (not-miraculix! bit-storing is used)}
}
\value{
contributions of each individual in selection
}
\description{
Function to simulate a step in a breeding scheme
}
\examples{
population <- creating.diploid(nsnp=1000, nindi=100, n.additive = 10)
population <- breeding.diploid(population, breeding.size=100, selection.size=c(25,25),
ogc = TRUE)
}
