% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilityFunctions.R
\name{mT.fitExtrapolationLaw}
\alias{mT.fitExtrapolationLaw}
\title{Fit interpolation law to a mortality table and extrapolate}
\usage{
mT.fitExtrapolationLaw(
  table,
  method = "LF2",
  law = "HP",
  fit = 75:99,
  extrapolate = 80:120,
  fadeIn = 80:90,
  fadeOut = NULL,
  raw = NULL
)
}
\arguments{
\item{table}{A life table object (instance of a \code{mortalityTable} class) or a list, table or array of mortalityTable objects}

\item{method}{The fitting method (passed on to [MortalityLaw])}

\item{law}{The mortality law fitted to the data(passed on to [MortalityLaw])}

\item{fit}{Age range to use for the fit}

\item{extrapolate}{Desired age range of the extrapolation (i.e. only those
ages will be extrapolated and added to the base table)}

\item{fadeIn}{age range to linearly fade in from the existing base table's values to the extrapolated}

\item{fadeOut}{age range to linearly fade out from the extrapolated base table's values to the existing}

\item{raw}{(optional) raw data to use for fitting. If not given, the raw
probabilities of the table (stored in \code{table@data$rawProbs})
or the table's base table (\code{table@deathProbs}) is used by default.}
}
\description{
Fit an extrapolation law (from the \code{MortalityLaws} Package to the base
table of the mortality table and use it for extrapolation.
}
\details{
The fit is done using the \code{MortalityLaws::MortalityLaw} function, with the ages, death counts, exposures and death rates taken from the \code{table} mortality table object. The law and the fitting method can be given in the \code{mT.fitExtrapolationLaw} with
the law and the fitting method

The age range \code{fit} is used to fit the law, while extrapolation is
applied only to ages given in parameter \code{extrapolate}. As fitting
does usually not result a smooth transition, a linear fade in or fade out
range can also be provided.
}
\examples{
mortalityTables.load("Austria_Census")
# use Austrian population mortalities for ages 18-95 and exponentially
# extrapolate them to lower ages
AT11.lowAges = mT.fitExtrapolationLaw(mort.AT.census.2011.male, law = "opperman",
                                      fit = 5:15, extrapolate = 0:15,
                                      fadeIn = NULL, fadeOut = 5:15)
AT11.oldAges = mT.fitExtrapolationLaw(mort.AT.census.2011.male, law = "HP",
                                      fit = 75:90, extrapolate = 75:120)
plotMortalityTables(mT.setName(AT11.lowAges, "Low ages fitted (ages 5-15 used)"),
                    mT.setName(AT11.oldAges, "old ages fitted (ages 75-90 used)"),
                    mort.AT.census.2011.male)
}
