% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherS.R
\name{FisherS}
\alias{FisherS}
\title{Variable-wise Type III Fisher tests}
\usage{
FisherS(
  formula,
  design,
  responses,
  term,
  alpha = 0.05,
  graph = TRUE,
  size.graph = 2.25
)
}
\arguments{
\item{formula}{A formula with no left term that specify the model from the elements of the \strong{design} argument.}

\item{design}{A data.frame that contains only factors specifying the design on which rely the specified model of \strong{formula} argument.}

\item{responses}{A matrix or data.frame that contains only numerics or integers being the responses variables to be explained by the model from \strong{formula}.}

\item{term}{A character specifying the term from \strong{formula} for which the MultLSD tests must be performed.}

\item{alpha}{The alpha risk to evaluate significance of the p-values of each Type III Fisher test. Variables will be colored differently according to their significance with \strong{graph=TRUE}.}

\item{graph}{A logical indicating whether or not variable-wise Type III Fisher statistics must be plotted together with their significance and average value.}

\item{size.graph}{If \strong{graph=TRUE}, the overall size of labels and titles.}
}
\value{
A matrix with two rows and as much columns as responses. The first row contains the Type III Fisher statistic and the second row contains the fdr correct p-value.
}
\description{
Computes the variable-wise Type III Fisher tests of a term from the model defined by \strong{formula}. This enables investigating the most discriminant variables for that term and possibly leads to variable selection.
}
\examples{
data(OTU)
fish=FisherS(~Lot+Atm+Time,OTU[,1:4],OTU[,-c(1:4)],"Time")
print(fish)
}
