% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqgsphh.r
\name{seqgsphh}
\alias{seqgsphh}
\title{Sequential generalized Hochberg and Hommel procedures based on group-sequential p-values}
\usage{
seqgsphh(
  pm = matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2),
  alpha = 0.025,
  epsilon = 1e-10,
  precision = 10,
  method = "Hochberg"
)
}
\arguments{
\item{pm}{Numeric matrix of group-sequential p-values for different
hypotheses (in row) at different times (in column).}

\item{alpha}{Numeric scalar of the overall family-wise error rate.}

\item{epsilon}{Numeric scalar indicating the lower bound for \code{alpha}.}

\item{precision}{Integer scalar for precision of the values, obsolete for
backward compatibility.}

\item{method}{"Hochberg" or "Hommel"}
}
\value{
List with elements
\itemize{
\item \code{rejected}: the index set of rejected hypotheses
\item \code{decisionsm}: rejection decision for each endpoint (row) at each timepoint
(column)
\item \code{cumdecisionsm}: cumulative rejection decision for each endpoint (row) at
each timepoint (column)
}
}
\description{
\code{seqgsphh()} implements the sequential Generalized Hochberg and Hommel
procedures based on group-sequential p-values.
}
\examples{
pm <- matrix(rep(c(0.03, 0.04, 0.01), times = 2), ncol = 3, nrow = 2)
seqgsphh(pm = pm, alpha = 0.025, method = "Hochberg")
seqgsphh(pm = pm, alpha = 0.025, method = "Hommel")
}
\author{
Xiaodong Luo
}
\concept{Hochberg procedure}
\concept{Hommel procedure}
\concept{group-sequential}
\concept{group-sequential p-values}
