% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_prior_distributions.R
\name{validate_all_priors}
\alias{validate_all_priors}
\title{Validate User-Specified Priors for Nimble Models}
\usage{
validate_all_priors(priors)
}
\arguments{
\item{priors}{A named list of priors specified as strings, where the name is the prior name (e.g., \code{prior_mean}) and the value is the prior distribution (e.g., \code{'dnorm(0, 0.001)'}).}
}
\value{
Returns \code{TRUE} if all priors are valid. Throws an error if any prior is invalid.
}
\description{
Validates a set of user-defined priors to ensure that they specify valid distributions supported by Nimble and have the correct parameters for each distribution.
}
\details{
The function checks the following:
\itemize{
\item Whether the specified distribution is supported by Nimble.
\item Whether the correct number of parameters is provided for the distribution.
}

If any prior is invalid, the function throws an informative error with details about the issue.
}
\references{
\itemize{
\item NIMBLE Development Team (2021). NIMBLE: An R Package for Programming with BUGS Models. \url{https://r-nimble.org/}
}
}
\seealso{
\itemize{
\item Nimble documentation for a full list of supported distributions.
}
}
