% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_func.R
\name{plotTrend}
\alias{plotTrend}
\title{Trend Tests Plots}
\usage{
plotTrend(
  data,
  covar = NULL,
  width,
  graph = c("summary", "variable1", "variable2", "window"),
  color = c("blue", "dark", "green", "warm")
)
}
\arguments{
\item{data}{Numeric matrix, a two dimensional data set where each column is a
variable.}

\item{covar}{Numeric vector, optional covariate vector, must be the same length as \code{data}.
Default is NULL.}

\item{width}{Integer, the width to be used for the \emph{moving window} algorithm.
Should be bigger than 1 and smaller than the number of observations.}

\item{graph}{Character vector, what will be plotted. Options are:
\itemize{
\item "summary", creates line plots of each variable, Kendall tau with moving window, and the results from the tests.
\item "variable1", creates a line plot of the first variable.
\item "variable2", creates a line plot of the second variable.
\item "window", creates scatter plot of Kendall tau using moving window.
}

Default is "summary".}

\item{color}{Character vector, plot color theme. Options are: "blue", "dark", "green", and "warm".}
}
\value{
The specified plot.
}
\description{
Informative plots on the given data series in regards to univariate
and multivariate trend testing.
}
\details{
The function is able to do three plots: "window" returns the scatter plot of
Kendall \eqn{\tau} with the moving window technique, "variable1" and "variable2"
return the line plots for each variable against the covariate or "Time", finally
"summary" returns the previous plot combined in the same display.
Four color profiles are available .
}
\examples{

\donttest{
# Sample data:
dataDependenceStructure <- generate_data("dependenceStructure", 50)
dataMarginalTrend <- generate_data("marginalTrend", 50)
dataNoTrend <- generate_data("noTrend", 50)

# Plot Trend summary:
plotTrend(dataDependenceStructure, covar = NULL, width = 10, graph = "summary", color = "blue")

plotTrend(dataMarginalTrend, covar = NULL, width = 10, graph = "summary", color = "green")

plotTrend(dataNoTrend, covar = NULL, width = 10, graph = "summary", color = "warm")

# Plot a variable
plotTrend(dataMarginalTrend, width = 10, graph = "variable1", color = "green")

# Plot the evolution of Kendall tau
plotTrend(dataDependenceStructure, width = 10, graph = "window", color = "warm")
}


}
\references{
Goutali, D., and Chebana, F. (2024). Multivariate overall and dependence trend tests, applied to hydrology,
Environmental Modelling & Software, 179, \doi{10.1016/j.envsoft.2024.106090}
}
\seealso{
\itemize{
\item \code{kendall.tau} : Function from the package \code{VGAM} used for computing the bivariate Kendall's \eqn{\tau}.
\item \code{rollapply} : Function from the package \code{zoo} used to apply the moving window technique.
}
}
