% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NADA_summary.R
\name{cenboxplot}
\alias{cenboxplot}
\title{Produces a censored boxplot}
\usage{
cenboxplot(obs, cen, group, log = TRUE, range = 0, ...)
}
\arguments{
\item{obs}{A numeric vector of observations.}

\item{cen}{A logical vector indicating TRUE where an observation in \code{obs} is
censored (a less-than value) and FALSE otherwise.}

\item{group}{A factor vector used for grouping \code{obs} into subsets (each group
will be a separate box).}

\item{log}{A logical indicating if the y-axis should be in log units.
Default is \code{TRUE}.}

\item{range}{A numeric value determining how far the plot whiskers extend
from the box. If positive, the whiskers extend to the most extreme data
point which is no more than \code{range} times the interquartile range from
the box. The default is 0, which extends whiskers to the min and max.}

\item{...}{Additional arguments passed to \code{\link[graphics:boxplot]{graphics::boxplot()}}.}
}
\value{
The output of the default \code{\link[graphics:boxplot]{graphics::boxplot()}} method.
}
\description{
Draws a boxplot with the highest censoring threshold shown as a horizontal line.
Any statistics below this line are invalid and must be estimated using methods for censored data.
}
\references{
Helsel, Dennis R. (2005). \emph{Nondetects and Data Analysis; Statistics for
censored environmental data}. John Wiley and Sons, Hoboken, NJ.
}
