% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anosimPlot.R
\name{anosimPlot}
\alias{anosimPlot}
\title{Permutation Analysis of Similarity (anosim) for Censored Data}
\usage{
anosimPlot(
  ano.out,
  hcol = "light blue",
  title = "Histogram of anosim permutations"
)
}
\arguments{
\item{ano.out}{an \code{anosim} object. See details and example}

\item{hcol}{color of histogram}

\item{title}{title of histogram}
}
\value{
Plots a histogram of the permutation test statistics representing the null hypothesis along with the observed test statistic from the data.  The p-value is the proportion of test statistics equal to or more extreme than the observed test statistic.
}
\description{
Plots the permutation histogram and test statistic produced by an anosim (nonparametric multivariate) test of differences between groups.
}
\examples{
data(PbHeron)

# ROS model for each group
PbHeron.high <- with(subset(PbHeron,DosageGroup=="High"),ros(Blood,BloodCen))
PbHeron.high <- data.frame(PbHeron.high)
PbHeron.high$DosageGroup <- "High"

PbHeron.low <- with(subset(PbHeron,DosageGroup=="Low"),ros(Blood,BloodCen))
PbHeron.low <- data.frame(PbHeron.low)
PbHeron.low$DosageGroup <- "Low"

PbHeron.ros=rbind(PbHeron.high,PbHeron.low)

# ANOSIM analysis
library(vegan)
PbHeron.anosim <- with(PbHeron.ros,anosim(modeled,DosageGroup))
summary(PbHeron.anosim)

# Plot
anosimPlot(PbHeron.anosim)
}
\references{
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Oksanen, J., Guillaume, F., 2018. Vegan: ecological diversity. CRAN R-Project. \url{https://cran.r-project.org/package=vegan}
}
\seealso{
\link[vegan:anosim]{vegan::anosim}
}
