% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\docType{data}
\name{transformations}
\alias{transformations}
\title{NAEP transformation constants.}
\format{
A data frame with columns
\describe{
\item{source}{source of data, character}
\item{level}{grade or age level of test, integer}
\item{assessmentCode}{"State" or "National", character}
\item{accommodations}{"accom" or "no-accom", character}
\item{subtest}{subtest within subject, character}
\item{subject}{subject of test, character}
\item{year}{year of test, integer}
\item{scale}{scale of subtest, numeric}
\item{location}{location of subtest, numeric}
\item{subtestWeight}{weight of subtest, numeric}
}
}
\usage{
transformations
}
\description{
This data table contains NCES NAEP Assessment transformation constants from 1990 to 2015.
To find the transformation constants for an assessment, filter the data table by level, subject,
and year. Some assessments also require filtering by assessmentCode and/or accommodations.
}
\examples{
\dontrun{

t <- NAEPirtparams::transformations
t8M2005 <- t[t$level == 8 & t$subject == 'Mathematics' & t$year == 2005 & is.na(t$assessmentCode), ]
head(t8M2005)
     source level   ...       subtest     subject year scale location subtestWeight
229 website     8   ...       algebra Mathematics 2005 35.64   281.79          0.30
228 website     8   ...          data Mathematics 2005 40.37   281.91          0.15
227 website     8   ...      geometry Mathematics 2005 33.22   275.64          0.20
226 website     8   ...   measurement Mathematics 2005 46.57   275.86          0.15
225 website     8   ...        number Mathematics 2005 37.78   277.11          0.20

}
}
\references{
Department of Education, Institute of Education Sciences, National Center for Education Statistics, National Assessment of Educational Progress (NAEP), 1990-2015, various subjects. Retrieved from \url{https://nces.ed.gov/nationsreportcard/tdw/analysis/trans_constants.aspx}
}
\keyword{datasets}
