% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{addRepresentation}
\alias{addRepresentation}
\title{Add representation}
\usage{
addRepresentation(NGLVieweR, type, param = list())
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{type}{Type of representation. Most common options are "cartoon",
"ball+stick", "line", "surface", "ribbon" and "label". For a full list of
options, see the "structureRepresentation" method in the official
\href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}

\item{param}{Options for the different types of representations. Most common
options are \code{name}, \code{opacity}, \code{colorScheme}, \code{sele},
\code{colorValue} and \code{visibility}. For a full list of options, see the
general "RepresentationParameters" method and type specific Label-,
Structure- and Surface- RepresentationParameters in the official
\href{http://nglviewer.org/ngl/api/}{NGL.js} manual.}
}
\value{
List of representation parameters to \code{NGLVieweR}
\code{htmlwidgets} object.
}
\description{
Add a representation and its parameters.
}
\examples{
NGLVieweR("7CID") \%>\%
  stageParameters(backgroundColor = "black") \%>\%
  addRepresentation("cartoon", 
  param = list(name = "cartoon", colorValue = "blue")) \%>\%
  addRepresentation("ball+stick",
    param = list(
      name = "ball+stick", sele = "241",
      colorScheme = "element", colorValue = "yellow"
    ) 
  ) \%>\%
  addRepresentation("label",
    param = list(
      name = "label",
      showBackground = TRUE,
      labelType = "res",
      color = "black",
      backgroundColor = "white",
      backgroundOpacity = 0.8,
      sele = ":A and 241 and .CG"
    )
  )

# Shiny context
if (interactive()) {
  library(shiny)
  ui <- fluidPage(NGLVieweROutput("structure"))
  server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        stageParameters(backgroundColor = "black") \%>\%
        addRepresentation("cartoon",
          param = list(name = "cartoon", colorValue = "blue")
        ) \%>\%
        addRepresentation("ball+stick",
          param = list(
            name = "ball+stick", sele = "241",
            colorScheme = "element"
          )
        ) \%>\%
        addRepresentation("label",
          param = list(
            name = "label",
            showBackground = TRUE,
            labelType = "res",
            colorValue = "black",
            backgroundColor = "white",
            backgroundOpacity = 0.8,
            sele = ":A and 241 and .CG"
          )
        )
    })
  }
  shinyApp(ui, server)
}
}
\seealso{
\itemize{
\item \code{\link[=addSelection]{addSelection()}}
\item \code{\link[=NGLVieweR_example]{NGLVieweR_example()}} See example "basic".
}
}
