#' Synthetic National Early Warning Scores Data
#'
#' Synthetic NEWS data to show as the results of the NHSR_synpop package.
#' These datasets have been synthetically generated by this package to be utilised in the NHSRDatasets package.
#'
#' @docType data
#'
#' @keywords datasets synthetic_news_data
#'
#' @format Tibble with twelve columns
#' \describe{
#' \item{male}{character string containing gender code}
#' \item{age}{age of patient}
#' \item{NEWS}{National Early Warning Score (NEWS)}
#' \item{syst}{Systolic BP - Systolic BP result}
#' \item{dias}{Diastolic Blood Pressure - result on NEWS scale}
#' \item{temp}{Temperature of patient}
#' \item{pulse}{Pulse of the patient}
#' \item{resp}{Level of response from the patient}
#' \item{sat}{SATS(Oxygen Saturation Levels) of the patient}
#' \item{sup}{Suppressed Oxygen score}
#' \item{alert}{Level of alertness of patient}
#' \item{died}{Indicator to monitor patient death}
#' }
#'
#' @source Generated by Dr. Muhammed Faisal and created by Gary Hutson \email{g.hutson@nhs.net}, Mar-2021
#'
#' @usage data(synthetic_news_data)
#'
#' @examples
#' library(magrittr)
#' library(dplyr)
#' data("synthetic_news_data")
#' synthetic_news_data %>%
#'  glimpse()
"synthetic_news_data"
