$PROBLEM    PK. With ignore statement.
;@ Variables 17/20 @;
$INPUT ROW ID TIME EVID CMT AMT DV MDV BBW

$DATA ./NMsimData_xgxr004_subprobs.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4
$PK
KA=THETA(1)*EXP(ETA(1))
V2=THETA(2)*EXP(ETA(2))
CL=THETA(3)*EXP(ETA(3))
V3=THETA(4)*EXP(ETA(4))
Q=THETA(5)*EXP(ETA(5))

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1)**2 + SIGMA(2,2)**2)
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA  (0,0.192558) ; POPKA
$THETA  (0,0.042) ; POPCL
$THETA  (0,0.783658) ; POPV2
$THETA  (0,0.208032) ; POPV3
$THETA  (0,1446770) ; POPQ
$OMEGA  0.265101
$OMEGA  0.138701
$OMEGA  1E-05
$OMEGA  0  FIX
$OMEGA  0  FIX
$SIGMA  0.0930259
$SIGMA  0.00302464


$SIMULATION ONLYSIM SUBPROBLEMS=4 (1873160888)

$TABLE      KA V2 CL V3 Q IPRED DV FILE=NMsim_xgxr004_subprobs.tab

