% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{tvARFiSm}
\alias{tvARFiSm}
\title{Filtering and Smoothing for Time-Varying AR Models}
\usage{
tvARFiSm(x, lags = c(1), include.mean = TRUE, par)
}
\arguments{
\item{x}{a time series of data.}

\item{lags}{the lag of AR order.}

\item{include.mean}{a logical value indicating whether the constant terms are included.}

\item{par}{the fitted time-varying AR models. It can be an object returned by function. \code{tvAR}.}
}
\value{
\code{trARFiSm} function return values returned by function \code{dlmFilter} and \code{dlmSmooth}.
}
\description{
This function performs forward filtering and backward smoothing for a fitted time-varying AR model with parameters in 'par'.
}
\examples{
t=50
x=rnorm(t)
phi1=matrix(0.4,t,1)
for (i in 2:t){
   phi1[i]=0.7*phi1[i-1]+rnorm(1,0,0.1)
	x[i]=phi1[i]*x[i-1]+rnorm(1)
}
est=tvAR(x,1)
tvARFiSm(x,1,FALSE,est$par)
}
