% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUETON_doc.R
\docType{package}
\name{NUETON-package}
\alias{NUETON}
\alias{NUETON-package}
\title{NUETON: Nitrogen Use Efficiency Toolkit on Numerics}
\description{
The \code{NUETON} package provides a comprehensive suite of tools for calculating
Nitrogen Use Efficiency (NUE) indicators from agricultural experimental data.
It includes vector-based calculations for 23 different parameters, batch processing
capabilities, and automated visualization tools.
}
\section{Getting Started}{

The quickest way to learn the package is to run the included demo script, which
demonstrates the batch processing and visualization features on a built-in dataset.

\preformatted{
# Run the master walkthrough
demo("nueton_walkthrough", package = "NUETON")
}
}

\section{Key Functions}{

\itemize{
  \item \code{\link{calculate_nue_batch}}: Automatically calculates all 23 indicators from a dataframe.
  \item \code{\link{plot_nue_compare}}: Visualizes the results with error bars.
  \item \code{\link{AE}}, \code{\link{NRE}}, \code{\link{NUEsoil}}: Individual parameter calculators.
}
}

\author{
\strong{Maintainer}: Shubham Love \email{shubhamlove2101@gmail.com}

}
